local roomForCorners = IsUsingWideScreen() or (GAMESTATE:GetNumPlayersEnabled() <= 1)
--placeholder variables:
local isFramed = false -- Might never be used, I've gotten too used to the UI without frames
local isMirrored = CheckShouldMirrorBG()

--local dispHeight = PREFSMAN:GetPreference("DisplayHeight")
--local useSmallerUI = dispHeight > 599
local UIScale = 1
--local UIScale = useSmallerUI and scale(dispHeight, 600, 800, 0.75, 0.9) or 1
--local UISCale = UIScaling()

local paraUI = THEME_EKSDGameMode == "Parapara" -- I don't remember what this would've been for

local isEx = ShouldUseEXGraphics()
local fileAppend = isEx and "ex_" or ""
local borderColor = isEx and LocalBlueColor(1) or LocalBlueColor(0)

local t = Def.ActorFrame {
	OnCommand=function(self)
		if isMirrored then
			SCREENMAN:GetTopScreen():GetChild("SongBackground"):zoomx(-1):x(_screen.w)
		end
	end,
	-- Let's add some flair
	Def.ActorFrame{
		Condition = roomForCorners and isFramed,
		--left side
		Def.Quad {
			OnCommand=function(self)
				self:xy(-20,140*UIScale):horizalign(left):valign(0.925):zoomto(140*UIScale,140*UIScale):rotationz(-45):diffuse(LocalBlueColor(0))
			end
		},
		LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
			OnCommand=function(self)
				self:xy(-20,140*UIScale):horizalign(left):vertalign(top):zoomto(140,20*UIScale):rotationz(-45):blend(Blend.Add)
			end
		},
		
		--right side
		Def.Quad {
			OnCommand=function(self)
				self:xy(_screen.w+5,140*UIScale):horizalign(left):valign(0.925):zoomto(140*UIScale,140*UIScale):rotationz(-45):diffuse(LocalBlueColor(0))
			end
		},
		LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
			OnCommand=function(self)
				self:xy(_screen.w+20,140*UIScale):horizalign(right):vertalign(top):zoomto(140,20*UIScale):rotationz(45)
			end
		},
	},
	
	Def.ActorFrame{
		Condition = isFramed,
		-- top
		Def.Quad {
			OnCommand=function(self)
				self:vertalign(top):xy(_screen.cx,0):zoomto(_screen.w,60*UIScale):diffuse(LocalBlueColor(0.3))
			end
		},
		-- lil' neon action
		LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
			OnCommand=function(self)
				self:xy(_screen.cx,60*UIScale):zoomto(_screen.w,20*UIScale):blend(Blend.Add)
			end
		},
		-- bottom
		Def.Quad {
			OnCommand=function(self)
				self:vertalign(bottom):xy(_screen.cx,_screen.h):zoomto(_screen.w,30*UIScale):diffuse(LocalBlueColor(0.3))
			end
		},
		LoadActor(THEME:GetPathG("_common", "smallneon")) .. {
			OnCommand=function(self)
				self:xy(_screen.cx,_screen.h-(20*UIScale)):vertalign(bottom):zoomto(_screen.w,20*UIScale):blend(Blend.Add)
			end
		},
	},
	
	-- Makeshift "frames" for UI MIN mode!
	LoadActor("lifescoreback") .. {
		Condition = not isFramed,
		OnCommand=function(self)
			self:vertalign(top):x(THEME:GetMetric("ScreenGameplay","LifeP1X")):y(2):zoom(1.01*UIScale):diffuse(Color.Black):glow(borderColor)
		end
	},
	LoadActor("lifescoreback") .. {
		Condition = not isFramed,
		OnCommand=function(self)
			self:vertalign(top):x(THEME:GetMetric("ScreenGameplay","LifeP2X")):y(2):zoomy(1.01*UIScale):zoomx(-1.01*UIScale):
				diffuse(Color.Black):glow(borderColor)
		end
	},
	Def.Quad{
		Condition = not isFramed and GAMESTATE:GetNumPlayersEnabled() > 1,
		OnCommand=function(self)
			self:xy(_screen.cx,38*UIScale):zoomto(180,40):diffuse(borderColor)
		end
	},
	
	-- Stage stuff.
	--TODO: separate this, probably
	LoadActor(fileAppend .. "stageback") .. {
		OnCommand=function(self)
			self:x(_screen.cx):y(18*UIScale):zoom(UIScale)
		end
	},
	Def.BitmapText {
		Font = "Common Large",
		Text = GAMESTATE:GetCurrentCourse() and "NONSTOP" or "STAGE",
		OnCommand=function(self)
			self:uppercase(true):x(_screen.cx):y(11*UIScale):strokecolor(Color.Black):zoom(0.6*UIScale):diffuse(isEx and LocalBlueColor(1) or Color.White)
		end
	},
	Def.BitmapText {
		Font = "Common Small",
		OnCommand=function(self)
			-- TODO: stage numbering in Event mode
			self:uppercase(true):x(_screen.cx):y(26*UIScale):strokecolor(Color.Black):zoom(0.5*UIScale):diffuse(isEx and LocalBlueColor(1) or Color.White)
			self:playcommand("Refresh")
		end,
		CurrentSongChangedMessageCommand=function(self) self:playcommand("Refresh") end,
		RefreshCommand=function(self)	
			if GAMESTATE:GetCurrentCourse() then
				local stats = STATSMAN:GetCurStageStats()
				if not stats then return end
				local mpStats = stats:GetPlayerStageStats( GAMESTATE:GetMasterPlayerNumber() )
				local songsPlayed = mpStats:GetSongsPassed() + 1
				self:settextf("%i / %i", songsPlayed, GAMESTATE:GetCurrentCourse():GetEstimatedNumStages());
			elseif GAMESTATE:IsEventMode() and GAMESTATE:GetCurrentStage() ~= "Stage_Demo" then
				self:settext(FormatNumberAndSuffix(GAMESTATE:GetCurrentStageIndex() + 1))
			else
				self:settext(StageToLocalizedString(GAMESTATE:GetCurrentStage()))
			end
		end
	},
	
	-- make this a scrolling marquee kinda deal at some point?
	-- Anyway, load a different file for demonstration/jukebox.
	LoadActor(GAMESTATE:GetCurrentStage() == "Stage_Demo" and "DemoTitle" or "SongTitle") .. {
		OnCommand=function(self)
			self:xy(_screen.cx,_screen.h-(16*UIScale))
		end
	},
	LoadActor("SongProgress") .. {
		OnCommand=function(self)
			local pl = GAMESTATE:GetMasterPlayerNumber() == PLAYER_1 and "P2" or "P1"
			self:xy(GAMESTATE:GetNumPlayersEnabled() <= 1 and THEME:GetMetric("ScreenGameplay","Life" .. pl .. "X") or _screen.cx,18*UIScale):zoom(UIScale)
		end
	}
}

for ip, pn in ipairs(GAMESTATE:GetHumanPlayers()) do
	-- "PlayerPanel" handles the things (score+life mainly) that need to be displayed on each player's side.
	t[#t+1] = LoadActor("PlayerPanel", pn) .. {
		OnCommand=function(self)
			self:xy(THEME:GetMetric("ScreenGameplay","Life" .. ToEnumShortString(pn) .. "X"),35*UIScale):zoom(UIScale)
		end
	}
end

return t